/*
 * @(#)SimulatedObject.java  2.1  2006-03-20
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.simulation;

import org.jhotdraw.xml.DOMStorable;
import java.beans.*;
import java.util.*;

/**
 * This is the interface of a simulated object.
 * <p>
 * After a SimulatedObject has been created it must be added to a simulation
 * using simulation.add(simulatedObject).
 * 
 * 
 * @author Werner Randelshofer
 * @version 2.1 2006-03-20 Added methods getConnectedElements() and 
 * getConnectedElements(int).
 * <br>2.0 2006-02-15 Upgraded to Java 1.5 type safe collectins.
 * <br>1.0 2. Dezember 2003  Created.
 */
public interface SimulatedObject extends Cloneable, DOMStorable {
    
    /**
     * This method is called by the simulation immediately after the element
     * has been added and before listener are informed about the adding.
     */
    public void addNotify(Simulation simulation);
    /**
     * This method is called by the simulation immediately before the element
     * has been removed and before listeners are informed about the removal.
     */
    public void removeNotify(Simulation simulation);
    

    
    /**
     * Returns an ID specifying the concept simulated by this element.
     */
    public int getSimulatedConcept();

    // LISTENER SUPPORT
    /**
     * Adds a listener for ElementEvent's.
     */
    public void addSimulatedObjectListener(SimulatedObjectListener l);
    
    /**
     * Removes a listener for ElementEvent's.
     */
    public void removeSimulatedObjectListener(SimulatedObjectListener l);
    /**
     * Adds a listener for PropertyChangeEvent's.
     */
    public void addPropertyChangeListener(PropertyChangeListener l);
    
    /**
     * Removes a listener for PropertyChangeEvent's.
     */
    public void removePropertyChangeListener(PropertyChangeListener l);
    
    /**
     * Returns the name of the object or null, if the object is unnamed.
     */
    public String getName();
    /**
     * Sets the name of the object.
     */
    public void setName(String newValue);
    
    /**
     * Returns true if the that object is of the same type, and
     * has the same attributes, such as the same name.
     */
    public boolean isEquivalent(SimulatedObject that);
}
